/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Kyle 09/09/08 USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL			*
 *	Kyle 09/10/08 CHANGE_PROTOTYPE_OF_HIDEPARAMROWS_AND_REMOVE_SETPARAMROWSSHOW	*
 *	Kyle 09/16/08 MOVE_DELETE_THIS_FROM_ONDESTROY_TO_GLOBAL_FUNCTION			*
 *	Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION								*
 *	Kyle 09/27/08 SET_BASE_LINE_PARAM_INDICES_TO_CONTROL						*
 *	Kyle 10/06/08 POST_MESSAGE_TO_XF_TO_ENABLE_FIT_BUTTON						*
 *	Kyle 10/07/08 CHECK_IF_NEED_TO_DELETE_THE_DIALOG_IN_ONDESTROY				*
 *	Folger 10/16/08 PA_FIT_CONTROL_DIALOG_NEED_TO_REMEBERE_AUTO_INIT_CHECKBOX_STATUS
 *	Folger 10/17/08 NEED_TO_UPDATE_PARAMS_TREE_INTO_PA_FIT_GETNTREE_WHEN_PEAK_FIT_DIALOG_CLOSE
 *  Iris 10/22/2008 MORE_ON_AUTO_INIT											*
 *  Iris 10/22/2008 NEW_PA_FIX_BUTTONS											*
 *	Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA					*
 *	Folger 10/28/08 v8.0962 CORRECTLY_UPDATE_PEAK_FIT_DIALOG_WHEN_SWITCH_PAGES	*
 *	Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
 *	Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE							*
 *	Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
 *	Sophy 12/2/2008 v8.981b UPDATE_OK_BUTTON_AND_RELATIVE_FIT_BUTTONS_ON_ERROR	*
 *  Iris 12/02/2008 v8.0981b QA80-12701 FIX_BACK_TO_BASECREATE_NOT_KEEP_BASELINE_FUNC_IF_CHANGE_FUNC_IN_FITPEAK*
 *	Sophy 12/3/2008 v8.0982 IMPROVE_PARAM_SETTING_DIALOG_GIVE_REASONAL_HINTS	*
 *	Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP				*
 *	Hong 12/10/08 QA80-12744 IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL	*
 *	Folger 12/15/08 v8.0986c PARAMETER_GRID_RUNTIME_ERROR_WHEN_CHANGE_FIX_STATUS_THEN_FIT
 *	Folger 01/05/09 v8.0993d REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
 *	Folger 01/06/09 8.0993e MAKE_MORE_CLEAR_PARAMETER_NAMES_PREFIX_FOR_HIDDEN	*
 *	Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN		*
 *	Folger 02/25/09 QA80-13181 SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING
 *	Folger 03/09/09 PROPER_HANDLE_OF_MAX_NUM_ITERATE_IN_FIT_PARAM_DIALOG		*
 *	Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
 *	Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT								*
 *	Folger 06/25/09 NANOSIZER_DO_NOT_NEED_TO_SUPPORT_SWITCH_PEAK_LABEL_FOR_SR6	*
 *	Folger 06/29/09 IMPROVE_HIDE_PARAMETER_DIALOG_IN_NANOSIZER					*
 *	Folger 07/14/09 NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION
 *	Folger 09/27/09 QA80-14380 FIT_PEAK_PARAMETERS_DIALOG_FAILS_TO_BE_MODALESS_WHEN_SWITCH_TO_OTHER_PAGES
 *	Folger 10/10/09 FUNCTION_COMBO_IN_PA_FAILS_TO_DISPLAY_WHOLE_CONTENT_UNDER_G_AND_J
 *	Folger 10/21/09 FIX_TOOLTIPS_IN_SWITCH_LABEL_BUTTON							*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include "PeakFitParameterDlg.h"

#define		PARMAS_GROUP_TYPE_NOT_SHARE_GROUP 		0 /// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP

// Start your functions here.
/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
//PFParamDlg::PFParamDlg(bool bMulFunc, bool bShowAdvBtn) : FitParaDlg()
PFParamDlg::PFParamDlg(PeakFitHelperBase* pPeakFitHelper, bool bMulFunc) : FitParaDlg()
///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
{
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	m_pPeakFitHelper = pPeakFitHelper;
	if( pPeakFitHelper && SetFitSession(pPeakFitHelper->GetFitSession()) )
	{
		m_pParamManager = m_pNLFitSession->GetNLParamsMngr();
	}
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
	
	m_strDlgName 	= _L("Peak Fit Parameters");
	
	m_bMulFunc 		= bMulFunc;
	//m_bShowAdvBtn 	= false;		/// button not ready
	
	m_vbFixButtons.SetSize(PFDLG_FIX_BUTTON_TOTAL);
	m_vbFixButtons = true;		
	
	//------ Folger 10/28/08 v8.0962 CORRECTLY_UPDATE_PEAK_FIT_DIALOG_WHEN_SWITCH_PAGES
	//m_bDeleteOnDestroy = true;		///Kyle 10/07/08 CHECK_IF_NEED_TO_DELETE_THE_DIALOG_IN_ONDESTROY
	//------
}

PFParamDlg::~PFParamDlg()
{
}

//static PFParamDlg* s_pPAPDlg = NULL;

//------ Folger 10/16/08 PA_FIT_CONTROL_DIALOG_NEED_TO_REMEBERE_AUTO_INIT_CHECKBOX_STATUS
/// virtual
BOOL	PFParamDlg::OnReady()
{
	BOOL bRet = FitParaDlg::OnReady();
	Button chkAutoInit = GetItem(IDC_PF_AUTO_INIT_CHECK);
	chkAutoInit.Check = m_pNLFitSession->GetAutoInitParams();
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	EnablePeakReorderingButton(m_pPeakFitHelper->GetPeakReorderingEnable());
	//------
	
	return bRet;
}
//------ End PA_FIT_CONTROL_DIALOG_NEED_TO_REMEBERE_AUTO_INIT_CHECKBOX_STATUS

/// virtual
void	PFParamDlg::initButtons()
{
	vector<string> vsTips;
	
	vsTips.Add(STR_TIP_INITIALIZE_PARAM);
	vsTips.Add(STR_TIP_CALCULATE_CHI_SQUARE);
	vsTips.Add(STR_TIP_ONE_ITERATION);
	vsTips.Add(STR_TIP_FIT_UNTIL_CONVERGED);
	vsTips.Add(STR_TIP_LOAD_PARAM_SETTINGS);
	///Sophy 12/3/2008 v8.0982 IMPROVE_PARAM_SETTING_DIALOG_GIVE_REASONAL_HINTS	
	//vsTips.Add("Apply to all parameters");	///Jasmine 10/17/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL, temp
	vsTips.Add("Quick set all parameters");	///Jasmine 10/17/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL, temp
	///end IMPROVE_PARAM_SETTING_DIALOG_GIVE_REASONAL_HINTS
	vsTips.Add(STR_SORT_PEAKS);		//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA
	vsTips.Add(STR_REORDER_PEAKS);
	vsTips.Add(STR_TIP_FIX_RELEASE_BASELINE_PARAM);
	vsTips.Add(STR_TIP_FIX_RELEASE_PEAKS_CENTER);
	vsTips.Add(STR_TIP_FIX_RELEASE_PEAKS_WIDTH);
	vsTips.Add(STR_TIP_SHARE_UNSHARE_WIDTH);
	
	vector<uint> vnBmpBtn = {IDC_PF_INIT, 	IDC_PF_CHI_SQ, 	IDC_PF_ONE_LTER,	IDC_PF_FIT, 	IDC_PF_AVANCED,	IDC_PF_QUICK_SET,	IDC_PF_SORT_PEAKS,	IDC_PF_REORDER_PEAKS, IDC_PF_FIXED_BASELINE,	IDC_PF_FIXED_CENTER,	IDC_PF_FIXED_WIDTH,	IDC_PF_SHARED_WIDTH};
	vector<uint> vnBmpIDs = {IDB_NLF_INIT, 	IDB_NLF_CHISQ, 	IDB_NLF_ITER, 		IDB_NLF_FIT,	IDB_PF_ADV, 	IDB_QUICK_SET,		IDB_SORT_PEAKS,		IDB_REORDER_PEAKS,		IDB_FIXED_BASELINE, 	IDB_FIXED_CENTER, 		IDB_FIXED_WIDTH, 	IDB_SHARED_WIDTH};
	
	int nSize = vsTips.GetSize();
	ASSERT( nSize == vnBmpBtn.GetSize() );
	ASSERT( nSize == vnBmpIDs.GetSize() );
	
	int nOneBitmapButton = 8;
	
	for(int ii = 0; ii < nSize; ii++)
	{
		vector<string> vsTip;
		vsTip.Add(_L(vsTips[ii]));
		
		UINT nStates = 1;
		UINT nBmpOffset = 0;
		if(ii >= nOneBitmapButton)
		{
			nStates = 2;
			vsTip.Add(_L(vsTips[ii]));	///Jasmine 06/10/08 NO_TIPS_SHOW_WHEN_FIXED_BASELINE_BTN_IS_SECOND_STATE
		}
				
		BitmapRadioButton btn = GetItem(vnBmpBtn[ii]);
		btn.Init(nStates, vnBmpIDs[ii], 16, vsTip, nBmpOffset);
		/// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
		if ( IDC_PF_QUICK_SET == vnBmpBtn[ii] )
			btn.Visible = false;
		/// end USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
	}
	
	//------ Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
	vector<string> vsTip;
	///------ Folger 10/21/09 FIX_TOOLTIPS_IN_SWITCH_LABEL_BUTTON
	//vsTip.Add(_L("Switch Peak Label"));
	string	strSwitchLabelTips = _L("Switch Peak Label");
	const	int	nSwitchLabelStates = 4;
	vsTip.SetSize(nSwitchLabelStates);
	for ( int nn=0; nn<nSwitchLabelStates; ++nn )
	{
		vsTip[nn] = strSwitchLabelTips;
	}
	///------ End FIX_TOOLTIPS_IN_SWITCH_LABEL_BUTTON
	BitmapRadioButton btn = GetItem(IDC_PF_SWITCH_PEAK_LABEL);
	btn.Init(nSwitchLabelStates, IDB_PEAK_LABEL_SWITCH, 16, vsTip, 0);
	//------ End SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
	
	//enable/disable fit buttons on fit 
	EnableFitButton(!m_pPeakFitHelper->IsFitConverged());
}
	
/// virtual 
void	PFParamDlg::updateControlsVisibility()
{		
	FitParaDlg::updateControlsVisibility();
	
	vector<uint> vnHideIDs = {IDC_PF_SIMPLX, 0};		
	for(int ii = 0; vnHideIDs[ii]; ii++)
		GetItem(vnHideIDs[ii]).Visible = false;
	
	//show use control
	vector<uint> vnShowIDs = {	IDC_PF_CHI_SQ, IDC_PF_AUTO_INIT_CHECK, 
								IDC_PF_FIXED_BASELINE, IDC_PF_FIXED_CENTER, IDC_PF_FIXED_WIDTH, 
								/// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
								//IDC_PF_HIDE, IDC_PF_QUICK_SET, IDC_PF_SORT_PEAKS, IDC_PF_REORDER_PEAKS, IDC_PF_SWITCH_PEAK_LABEL, 0};	///Jasmine 04/09/08 ADD_FIX_RELEASE_BUTTONS	
								IDC_PF_HIDE, IDC_PF_SORT_PEAKS, IDC_PF_REORDER_PEAKS, IDC_PF_SWITCH_PEAK_LABEL, 0};	///Jasmine 04/09/08 ADD_FIX_RELEASE_BUTTONS	
								/// end USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
	///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
	//if(m_bMulFunc)
		//vnShowIDs.InsertAt(0, IDC_PF_COMBO);
	//else
		//vnShowIDs.InsertAt(0, IDC_PF_SHARED_WIDTH);
	vnShowIDs.InsertAt(0, IDC_PF_COMBO);
	if ( !m_bMulFunc )
	{
		vnShowIDs.InsertAt(0, IDC_PF_SHARED_WIDTH);
		///------ Folger 06/25/09 NANOSIZER_DO_NOT_NEED_TO_SUPPORT_SWITCH_PEAK_LABEL_FOR_SR6
		#ifndef		__SHOW_PEAK_LABEL_SWITCH_BUTTON_FOR_NANOSIZER__
		vector<uint>	vnIndices;
		if ( vnShowIDs.Find(vnIndices, IDC_PF_SWITCH_PEAK_LABEL) > 0 )
			vnShowIDs.RemoveAt(vnIndices[0]);
		#endif		/// !__SHOW_PEAK_LABEL_SWITCH_BUTTON_FOR_NANOSIZER__
		///------ End NANOSIZER_DO_NOT_NEED_TO_SUPPORT_SWITCH_PEAK_LABEL_FOR_SR6
	}
	///------ End NANOSIZER_FITTING_BASED_SUPPORT
	for(ii = 0; vnShowIDs[ii]; ii++)
		GetItem(vnShowIDs[ii]).Visible = true;
	
	GetItem(IDC_PF_AVANCED).Visible = m_bShowAdvBtn;
		
}

/// virtual 
bool	PFParamDlg::initParaGrid(int nID, Dialog& dlg, LPCSTR lpcszDlgName)
{
	if(NULL == m_pGridParas)
	{
		///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
		//m_pGridParas = new MultiFuncFParamsControl(m_bMulFunc);
		m_pGridParas = new MultiFuncFParamsControl(m_pPeakFitHelper->GetPeakFuncCategory(), m_pPeakFitHelper->GetBaselineFuncCategory(), m_bMulFunc);
		///------ End NANOSIZER_FITTING_BASED_SUPPORT
	}
	
	/// Iris 10/30/2008 v8.0963b DISABLE_BASELINE_PARAMETER_SHARE_CELL
	/////Kyle 09/27/08 SET_BASE_LINE_PARAM_INDICES_TO_CONTROL
	//vector<int> vnIndices;
	//if( m_pPeakFitHelper->GetBaselineParamIndices(vnIndices) )
		//m_pGridParas->SetBaselineParamIndices(vnIndices);
	/////End SET_BASE_LINE_PARAM_INDICES_TO_CONTROL
	///end DISABLE_BASELINE_PARAMETER_SHARE_CELL
	
	/// Hong 12/10/08 QA80-12744 IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL
	//return FitParaDlg::initParaGrid(nID, dlg, lpcszDlgName);
	if ( !FitParaDlg::initParaGrid(nID, dlg, lpcszDlgName) )
		return false;
	
	if ( m_bMulFunc )		
		m_pGridParas->SetSelection(flexSelectionListBox);
	return true;
	/// end IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL
}


BOOL	PFParamDlg::OnDestroy()
{
	//------ Folger 10/17/08 NEED_TO_UPDATE_PARAMS_TREE_INTO_PA_FIT_GETNTREE_WHEN_PEAK_FIT_DIALOG_CLOSE
	post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_DIALOG_CLOSE, 0);
	//------
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	Button btnReorder = GetItem(IDC_PF_REORDER_PEAKS);
	m_pPeakFitHelper->SetPeakReorderingEnable(btnReorder.Enable);
	//------
	
	///------ Folger 01/05/09 v8.0993d REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
	m_pPeakFitHelper->SetGetParamHideTree(m_trParamHide, true);
	///------ End REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
	
	if(FitParaDlg::OnDestroy())
	{
		///Kyle 10/07/08 CHECK_IF_NEED_TO_DELETE_THE_DIALOG_IN_ONDESTROY
		//delete this;
		//s_pPAPDlg = NULL;
		//------ Folger 10/28/08 v8.0962 CORRECTLY_UPDATE_PEAK_FIT_DIALOG_WHEN_SWITCH_PAGES
		//if(m_bDeleteOnDestroy)
		//{
			//delete this;
			//s_pPAPDlg = NULL;
		//}
		m_pPeakFitHelper->SetPeakFitDlgPointer(NULL);
		delete this;
		//------ End CORRECTLY_UPDATE_PEAK_FIT_DIALOG_WHEN_SWITCH_PAGES
		///End CHECK_IF_NEED_TO_DELETE_THE_DIALOG_IN_ONDESTROY
		return TRUE;
	}
	return FALSE;
}


BOOL	PFParamDlg::OnComboChangeFunction(Control ctrl)
{
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	/*
	m_vnParamsHide.SetSize(0);
	customParamRowsShow();
	
	int nPeaks = 0;
	
	if(m_trPFM.Peaks)
	{
		TreeNode trlastPeak = m_trPFM.Peaks.LastNode;
		if(trlastPeak)
		{
			string strPeakName = trlastPeak.tagName;
			strPeakName.TrimLeft("Preak");
			nPeaks = atoi(strPeakName);
		}
	}
	
	if(0 < nPeaks)
	{
		vector<int> vnChangePeakNOs(nPeaks);
		vnChangePeakNOs.Data(1, nPeaks);
		
		ComboBox combo = GetItem(IDC_PF_COMBO);
		string strFunction;
		combo.GetLBText(combo.GetCurSel(), strFunction);
		
		vector<string> vsPeakTypes(nPeaks);
		for(int ii = 0; ii < nPeaks; ii++)
			vsPeakTypes[ii] = strFunction;
		
		onChangePeakType(vnChangePeakNOs, vsPeakTypes);
	}
	*/	
	ComboBox combo = GetItem(IDC_PF_COMBO);
	string strFunction;
	combo.GetLBText(combo.GetCurSel(), strFunction);
	
	if( 0 == strcmp(m_strComboOldFunction, strFunction) )
		return FALSE;
	m_strComboOldFunction = strFunction;
	m_pPeakFitHelper->SetDefaultFunction(strFunction);
		
	int		nPeaks = m_pNLFitSession->GetNumPeaks();	
	vector<int> vnPeakIndecies;
	vnPeakIndecies.Data(0, nPeaks-1, 1);
	
	if ( m_pPeakFitHelper->IsBaselineFitWithPeaks() )
	{
		ASSERT(nPeaks);
		vnPeakIndecies.RemoveAt(0);
		--nPeaks;
	}
	
	vector<string> vsFunctions(nPeaks);
	for(int ii = 0; ii < nPeaks; ii++)
		vsFunctions[ii] = strFunction;	
		
	PEAKINFOARGUMENTSLISTFUNCTIONS stPEAKINFOARGUMENTSLISTFUNCTIONS;
	stPEAKINFOARGUMENTSLISTFUNCTIONS.vsFunctions = vsFunctions;
	
	m_pPeakFitHelper->SetFunctions(vsFunctions, true);	
	/// Iris 10/22/2008 MORE_ON_AUTO_INIT
	//if( checkedAutoInit() ) 
	//	m_pPeakFitHelper->ReinitParamsOnFuncChange(vnPeakIndecies, &stPEAKINFOARGUMENTSLISTFUNCTIONS);
	m_pPeakFitHelper->ReinitParamsOnFuncChange(vnPeakIndecies, &stPEAKINFOARGUMENTSLISTFUNCTIONS, !checkedAutoInit() );
	///end MORE_ON_AUTO_INIT
	
	onAfterFunctionChanged();
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
	
	///------ Folger 02/25/09 QA80-13181 SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING
	if ( !m_pPeakFitHelper->IsBaselineFitWithPeaks() )
	{
		m_pPeakFitHelper->CheckSetBaseParamFixMode();
	}
	///------ End SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING
	
	///------ Folger 07/14/09 NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION
	if ( !m_bMulFunc )
		ResetParamHideTree();
	///------ End NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION
	UpdateParameterHide(false);		///------ Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
	
	return TRUE;
}

/// virtual
int		PFParamDlg::getButtonIDs(vector<uint>& vnButtonIDs)
{	
	vector<uint> vnBottomGroup = {
			IDOK, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_GROUP_GAP, 
			IDC_PF_FIT, IDC_PF_ONE_LTER, IDC_PF_CHI_SQ, IDC_PF_INIT, IDC_GROUP_GAP, 
			/// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
			//IDC_PF_AVANCED, IDC_PF_QUICK_SET, 
			IDC_PF_AVANCED,
			/// end USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
			IDC_PF_FIXED_WIDTH, IDC_PF_FIXED_CENTER, IDC_PF_FIXED_BASELINE, IDC_PF_SHARED_WIDTH, IDC_GROUP_GAP, IDC_PF_SORT_PEAKS, IDC_PF_REORDER_PEAKS, IDC_PF_SWITCH_PEAK_LABEL,
			0
	};
	
	vnButtonIDs = vnBottomGroup;	
	int nSize = vnButtonIDs.GetSize();
	if(0 == vnButtonIDs[nSize-1])
		nSize--;
	return nSize;
}

/// virtual
void	PFParamDlg::initAfterUpdate()
{	
	ComboBox combo = GetItem(IDC_PF_COMBO);
	if( combo && combo.Visible )
	{
		RECT rCombo;
		GetClientRect(combo, rCombo);
		
		int nEdge 	= GetControlGap();
		int nDx 	= nEdge -rCombo.left;
		
		vector<uint> nIDs = {IDC_PF_COMBO, 0};
		MoveControls(nIDs, nDx, 0);
	
		/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
		/*
		TreeNode 	trPara 		= GetParameterTreeFromGrid();
		TreeNode 	trPeakType 	= trPara.PeakType;
		if(trPeakType)
		{
			string strFunctions;
			trPeakType.GetAttribute(STR_COMBO_ATTRIB, strFunctions);
			
			vector<string> vsFuncs;
			int nCount = strFunctions.GetTokens(vsFuncs, '|');
			for (int ii = 0; ii < nCount; ii++)
			{
				combo.InsertString(ii, vsFuncs[ii]);
			}
			
			combo.SetCurSel(0);
		}
		*/
		combo.ResetContent();
		
		char 	chSep = '|';
		string 	strFunctions = get_function_list(m_pPeakFitHelper->GetPeakFuncCategory());
		if( !strFunctions.IsEmpty() )
		{
			int		nSel = 0;
			for(int ii = 0; ii < strFunctions.GetNumTokens(chSep); ii++)
			{
				string strFunc = strFunctions.GetToken(ii, chSep);
				if ( strFunc.CompareNoCase(m_pPeakFitHelper->GetDefaultFunction()) == 0 )
					nSel = ii;
				combo.AddString( strFunc );
			}
			combo.SetCurSel(nSel);
			///------ Folger 10/10/09 FUNCTION_COMBO_IN_PA_FAILS_TO_DISPLAY_WHOLE_CONTENT_UNDER_G_AND_J
			combo.SetDroppedVisibleItemCount();
			///------ End FUNCTION_COMBO_IN_PA_FAILS_TO_DISPLAY_WHOLE_CONTENT_UNDER_G_AND_J
			//combo.GetLBText(combo.GetCurSel(), m_strComboOldFunction);
			m_strComboOldFunction.Empty();
		}
		///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
	}
}

///Jasmine 04/14/10 QA81-15304 ANNOUNCE_FITTING_FUNC_CHANGE
//virtual 
BOOL PFParamDlg::OnFittingFuncChange(uint wParam, uint lParam)
{
	//function list in parameter grid is updated before edit,
	//so this function only update function combo control
	initAfterUpdate();
	return TRUE;
}
///End ANNOUNCE_FITTING_FUNC_CHANGE

typedef bool (* LOAD_INI_FILE_FUNC)(LPCSTR lpcszFilename, TreeNode& trSetting, BOOL bUseIniPath);

BOOL	PFParamDlg::OnAdvanced(Control ctrl)
{	
	string strSettingFile;
	vector<string> vsFileTypes(1);
	vsFileTypes[0] = "[*.ini] *ini";
	if( okutil_FileDialog(&strSettingFile, false, &vsFileTypes, GetAppPath(), 0, GetSafeHwnd(), _L("Parameter Settings File")) )
	{		
		string 	strFile = "Originlab\\FitINIFile";	
	
		LOAD_INI_FILE_FUNC pf = Project.FindFunction("fit_ini_file_load_setting", strFile, true);
		
		Tree trSetting;
		if( pf && pf(strSettingFile, trSetting, FALSE) )
		{
			MessageBox(GetSafeHwnd(), "It's not ready, haha:D");
			return TRUE;
			return updateParameterSettingsFromTree(trSetting);
		}
	}
	return FALSE;
}

bool	PFParamDlg::updateParameterSettingsFromTree(const TreeNode& trParams)
{
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS, to do 
	/*
	string 			strFunctionList, strFunctions;
	vector<string>	vsFunctions;
	if(trParams)
	{
		if(trParams.Parameters && trParams.Parameters.Functions)
			vsFunctions = trParams.Parameters.Functions.strVals;
		
		if(trParams.Baseline && trParams.Baseline.Function)
			vsFunctions.InsertAt(0, trParams.Baseline.Function.strVal);
		
		strFunctionList.SetTokens(vsFunctions, '|');			
	}
	foreach(TreeNode trPeak in m_trPFM.Peaks.Children)
	{
		strFunctions += trPeak.Function.FuncName.strVal + "|";
	}
	strFunctions.TrimRight("|");
	if(strFunctions.IsEmpty() || strFunctionList.IsEmpty() || 0 != strFunctions.Find(strFunctionList))
		return false;
	
	//doing...
	
	return true;
	*/
	return false;
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
}

BOOL	PFParamDlg::OnInitParamValue(Control ctrl)
{
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS, to do 
	/*
	vector vInitValues;
	vector<string> vsInitValues;
	tree_get_attributes(m_trPFM.Peaks, vsInitValues, STR_CHANGED_ATTRIB);
	remove_empty_item(vsInitValues);
	convert_str_vector_to_num_vector(vsInitValues, vInitValues);
	
	vector<int> vnFixed;
	m_pNLFitSession->GetParamsSettingIntVector(vnFixed, PARMAS_SETTING_FIXED);
	int nFixSum = 0;
	vnFixed.Sum(nFixSum);
	if(0 < nFixSum)
	{
		vector vValues;
		m_pNLFitSession->GetParamsSettingDoubleVector(vValues, PARMAS_SETTING_VALUES);
		
		int nSize 		= vInitValues.GetSize();
		int nFixSize 	= vnFixed.GetSize();
		int nValueSize 	= vValues.GetSize();
		for(int ii = 0; ii < nSize; ii++)
		{
			if(ii >= nFixSize || ii >= nValueSize)
				break;
			
			if( vnFixed[ii] )
			{
				vInitValues[ii] = vValues[ii];
			}
		}
	}
	
	if(vInitValues.GetSize() && 0 == m_pNLFitSession->SetParamValues(vInitValues)) 
	{
		if( EXIST_PLOT == m_pg.GetType() )
		{
			m_pNLFitSession->UpdateFitSessionPreviewData(false);
		}
		
		updateParameters();
		bool bEnable = true;
		EnableFitButton(bEnable);
		
		int nSetting = pfm_combine_exmsg_parachange_setting(bEnable, PARMAS_SETTING_VALUES);		
		post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_PARA_CHANGE, nSetting);
		return TRUE;
	}
	return FALSE;
	*/
	if(m_pPeakFitHelper->InitParams())
	{
		///Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION
		//m_pGridParas->Update();
		m_pGridParas->Update( m_pNLFitSession->IsAllowSharing() );
		///End USE_ISALLOWSHARING_IN_NLFSESSION
		EnableFitButton(true);
		
		///Kyle 10/06/08 POST_MESSAGE_TO_XF_TO_ENABLE_FIT_BUTTON
		///Iris 10/22/2008 UPDATE_PREVIEW_FOLLOW_RETURN_VAL_OF_PARAMMANAGER_ONEDIT
		//int nSetting = pfm_combine_exmsg_parachange_setting(true, PARMAS_SETTING_VALUES);		
		//post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_PARA_CHANGE, nSetting);
		int nNeedUpdatePreview = 1;
		post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_PARA_CHANGE, nNeedUpdatePreview); 
		///end UPDATE_PREVIEW_FOLLOW_RETURN_VAL_OF_PARAMMANAGER_ONEDIT
		///End POST_MESSAGE_TO_XF_TO_ENABLE_FIT_BUTTON
		return true;
	}
	return false;
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
}

bool	PFParamDlg::checkedAutoInit()
{
	Button chkAutoInit = GetItem(IDC_PF_AUTO_INIT_CHECK);
	return chkAutoInit.Check;	
}

BOOL	PFParamDlg::OnCheckAutoInit(Control ctrl)
{
	Button chkAutoInit = GetItem(IDC_PF_AUTO_INIT_CHECK);
	if(NULL != m_pNLFitSession)
	{
		m_pNLFitSession->SetAutoInitParams( checkedAutoInit() );
		post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_CHECK_AUTOINIT, IDE_NL_PARAMS_AUTO_INIT);
		return TRUE;
	}
	return FALSE;
}

BOOL	PFParamDlg::updateFixReleaseButton(int nBtnID)
{
	Button 	btn 	= GetItem(nBtnID);
	bool 	bFix 	= btn.Check;
	bool 	bChange	= false;	
	bool 	bRet 	= false;
	//int 	nSetting= PARMAS_SETTING_FIXED; /// Iris 10/22/2008 NEW_PA_FIX_BUTTONS not used now
	int 	nParts = 0;
	
	switch ( nBtnID )
	{
		case IDC_PF_FIXED_BASELINE:
			/// Iris 10/22/2008 NEW_PA_FIX_BUTTONS
			//bRet = m_pNLFitSession->FixBaseline(bFix, &bChange);
			bChange = true;
			nParts = getNLParamMngr()->FixBaseline(&bFix);
			///end NEW_PA_FIX_BUTTONS
			///------ Folger 02/25/09 QA80-13181 SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING
			m_pPeakFitHelper->CheckSetBaseParamFixMode(&bFix);
			///------ End SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING
			break;
			
		case IDC_PF_FIXED_CENTER:
			/// Iris 10/22/2008 NEW_PA_FIX_BUTTONS
			//bRet = m_pNLFitSession->FixPeaksCenterWidth(bFix, true, false, &bChange);
			bChange = true;
			nParts = getNLParamMngr()->FixPeaksCenterAndWidth(&bFix, true);
			///end NEW_PA_FIX_BUTTONS
			break;
			
		case IDC_PF_FIXED_WIDTH:
			/// Iris 10/22/2008 NEW_PA_FIX_BUTTONS
			//bRet = m_pNLFitSession->FixPeaksCenterWidth(bFix, false, true, &bChange);
			bChange = true;
			nParts = getNLParamMngr()->FixPeaksCenterAndWidth(&bFix, false);
			///end NEW_PA_FIX_BUTTONS
			break;
			
		case IDC_PF_SHARED_WIDTH:
			/// Iris 10/22/2008 NEW_PA_FIX_BUTTONS
			//bRet = m_pNLFitSession->SharePeaksWidth((int)bFix, &bChange);
			//nSetting = PARMAS_SETTING_SHARE;
			bChange = true;
			nParts = getNLParamMngr()->SharePeaksWidth(&bFix);
			///end NEW_PA_FIX_BUTTONS
			break;
			
		default:
			break;
	}
	
	/// Iris 10/22/2008 NEW_PA_FIX_BUTTONS
	//if ( !bRet )
	//	return false;
	if( nParts & NLDLGPART_FIT_FUNC_BTNS )
	{
		EnableFitButton(true);
	}
	///end NEW_PA_FIX_BUTTONS
	
	if ( bChange ) 
	{
		updateParameters();	
		
		/// Iris 10/22/2008 NEW_PA_FIX_BUTTONS, fix parameter no need update preview
		//nSetting = pfm_combine_exmsg_parachange_setting(true, nSetting);			
		//post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_PARA_CHANGE, nSetting);
		int nUpdatePerview = 0;
		post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_PARA_CHANGE, nUpdatePerview);
		///end NEW_PA_FIX_BUTTONS
	}
	
	return TRUE;
}

BOOL	PFParamDlg::OnToggleFixBaseline(Control ctrl)
{
	return updateFixReleaseButton(IDC_PF_FIXED_BASELINE);
}

BOOL	PFParamDlg::OnToggleFixPeakCenter(Control ctrl)
{
	return updateFixReleaseButton(IDC_PF_FIXED_CENTER);
}

BOOL	PFParamDlg::OnToggleFixPeakWidth(Control ctrl)
{
	return updateFixReleaseButton(IDC_PF_FIXED_WIDTH);
}

/// virtual
BOOL	PFParamDlg::OnToggleSharePeakWidth(Control ctrl)
{
	return updateFixReleaseButton(IDC_PF_SHARED_WIDTH);
}

//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA
/// virtual
BOOL	PFParamDlg::OnSortPeaks(Control ctrl)
{
	//------ Folger 11/04/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	//vector<uint>	vnIndices;
	//int		nUpdateParts = m_pGridParas->OnSortPeaks(m_bMulFunc, &vnIndices);
	int		nUpdateParts = m_pGridParas->OnSortPeaks(m_bMulFunc);
	
	if ( nUpdateParts > 0 )
	{
		//if ( nUpdateParts & NLDLGPART_FIT_CONTROL_BTNS )
			//EnableFitButton(true);
				//
		//m_pPeakFitHelper->UpdatePeaksCenterAndWidthAfterSorting(vnIndices);
		EnablePeakReorderingButton(true);
	}
	//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	return true;
}
//------ End SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA

//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
/// virtual
BOOL	PFParamDlg::OnReorderPeaks(Control ctrl)
{
	vector<uint>	vnIndices;
	int		nUpdateParts = m_pGridParas->OnReorderPeaks(&vnIndices);
	
	if ( nUpdateParts > 0 )
	{
		if ( nUpdateParts & NLDLGPART_FIT_CONTROL_BTNS )
			EnableFitButton(true);
				
		m_pPeakFitHelper->UpdatePeaksPropertiesAfterSorting(vnIndices);
		EnablePeakReorderingButton(false);
	}
	
	return TRUE;
}
//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING

//------ Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
///virtual
BOOL	PFParamDlg::OnSwitchPeakLabel(Control ctrl)
{
	Button	btn = ctrl;
	m_pPeakFitHelper->AccessPeakLabelSettings(btn.Check, false);
	return TRUE;
}
//------ End SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
	
/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS, not use m_trPFM and m_pg in this class any more
/*
void	PFParamDlg::onChangePeakType(const vector<int>& vnPeakNOs, const vector<string>& vsPeakTypes)
{
	int nSize = vnPeakNOs.GetSize();
	if(0 == nSize)
		return;
	
	TreeNode trPeaks = m_trPFM.GetNode(PFM_PEAKS_TREE_TAG_NAME);
	if(!trPeaks)
		return;
	
	int nValidItems = 0;
	for(int ii = 0; ii < nSize && ii < vsPeakTypes.GetSize(); ii++)
	{
		string strFunction = vsPeakTypes[ii];
		if( strFunction.IsEmpty() )
			continue;
		
		int nPeak = vnPeakNOs[ii];
		TreeNode trPeak = trPeaks.GetNode("Peak" + nPeak);
		if(!trPeak)
			continue;
		
		TreeNode trFunc = trPeak.GetNode(BRANCH_FUNCTION_IN_PFM_TREE);
		TreeNode trFunction = trFunc.GetNode(TAG_FUNCNAME_IN_PFM_TREE);
		if( !trFunction || 0 == strFunction.CompareNoCase(trFunction.strVal) )
			continue;
		
		trPeak.SetAttribute(STR_CHANGED_ATTRIB, trFunction.strVal);
		trFunction.strVal = strFunction;
		nValidItems++;
	}
	
	if(0 < nValidItems)
	{
		HWND hwnd;
		Tree tr;
		if(load_GetN_from_page(m_pg, tr,  hwnd, STR_STORAGE_NAME))
		{
			TreeNode trPFM = tr.GetNode(PFW_TREE_TAG_NAME);//PFM_PEAKS_TREE_TAG_NAME	
			if(trPFM)
			{
				trPFM.Replace(m_trPFM, true, true);
				save_GetN_to_page(m_pg, tr,  hwnd, STR_STORAGE_NAME);
				
				post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_FUNC_CHANGE);
			}
		}
	}
	return;
}
*/
//end PA_PARAM_DLG_USE_NEW_FIT_CLASS

void	PFParamDlg::OnAfterEditParaControl(Control flxControl, int nRow, int nCol)
{
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	// if function name not changed then no need call Fit Helper to init params
	
	int nRowWithoutOffset = nRow - m_pGridParas->GetRowOffset();
	
	bool bFunctionChanged = false;
	if(NLPARAMGRIDCOLTYPE_FUNC_NAME == nCol)
	{
		vector<string> vs;
		getNLParamMngr()->GetColumn(NLPARAMGRIDCOLTYPE_FUNC_NAME, vs);
		if( 0 != lstrcmp(m_pGridParas->GetCell(nRow, nCol), vs[nRowWithoutOffset]) ) // case sensitive for function name? 
			bFunctionChanged = true;
	}
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS		
	
	FitParaDlg::OnAfterEditParaControl(flxControl, nRow, nCol);
	
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	//if(GRID_COL_PEAK_TYPE == nCol)
	if(NLPARAMGRIDCOLTYPE_FUNC_NAME == nCol && bFunctionChanged)
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
	{
		/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
		/*
		m_vnParamsHide.SetSize(0);
		customParamRowsShow();
		
		vector<int> vnChangePeakNOs;
		vector<string> vsPeakTypes;
		vnChangePeakNOs.Add(nRow);
		m_pGridParas->GetPeakTypesInfo(vnChangePeakNOs, vsPeakTypes);
		onChangePeakType(vnChangePeakNOs, vsPeakTypes);
		*/
		
		m_strComboOldFunction.Empty();
		
		vector<string> 	vsPeakNOs;
		getNLParamMngr()->GetColumn(NLPARAMGRIDCOLTYPE_PEAK_NO, vsPeakNOs);
		//int nPeak = atoi(vsPeakNOs[nRowWithoutOffset]) - (m_pPeakFitHelper->IsBaselineFitWithPeaks() ? 0 : 1);
		int nPeak = atoi(vsPeakNOs[nRowWithoutOffset]) - (m_pPeakFitHelper->IsBaselineFitWithPeaks() || nRowWithoutOffset == 0 ? 0 : 1);
		
		vector<int> 	vnPeakIndecies;
		vnPeakIndecies.Add(nPeak);		
		
		string strFunction = m_pGridParas->GetCell(nRow, nCol);
		if( strFunction.IsEmpty() )
		{
			ASSERT(0);
			return;
		}
		m_pPeakFitHelper->SetFunction(strFunction, nPeak);
		
		/// Iris 10/22/2008 MORE_ON_AUTO_INIT
		//if( checkedAutoInit() )
		//	m_pPeakFitHelper->ReinitParamsOnFuncChange(vnPeakIndecies);
		m_pPeakFitHelper->ReinitParamsOnFuncChange(vnPeakIndecies, NULL, !checkedAutoInit());
		///end MORE_ON_AUTO_INIT
		
		onAfterFunctionChanged();
		///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
		
		/// Folger, 12/03/08, I think this code is not correct, need to talk to Iris
		///// Iris 12/02/2008 v8.0981b QA80-12701 FIX_BACK_TO_BASECREATE_NOT_KEEP_BASELINE_FUNC_IF_CHANGE_FUNC_IN_FITPEAK
		//if(m_pPeakFitHelper->IsBaselineFitWithPeaks() && 0 == nPeak) // if changed baseline function
		//{
			//vector vParams;
			//getNLParamMngr()->GetParamValues(vParams);
			//
			//vector<string> vParamNames;
			//nlsf_get_param_names(strFunction, vParamNames, STR_PA_NLSF_CAT_BASELINE);
			//
			//m_pPeakFitHelper->SetBaselineInfo(&vParams, &vParamNames, strFunction);
		//}
		/////end FIX_BACK_TO_BASECREATE_NOT_KEEP_BASELINE_FUNC_IF_CHANGE_FUNC_IN_FITPEAK
		
		///------ Folger 02/25/09 QA80-13181 SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING
		if ( nPeak == 0 )		/// first peak, baseline peak or peak with baseline parameter
		{
			m_pPeakFitHelper->CheckSetBaseParamFixMode();
		}
		///------ End SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING
		
		UpdateParameterHide(false);		///------ Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
		
		return;
	}
	///------ Folger 02/25/09 QA80-13181 SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING
	else if ( NLPARAMGRIDCOLTYPE_FIXED == nCol )
	{
		m_pPeakFitHelper->CheckSetBaseParamFixMode();
	}
	///------ End SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING
	
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	/*	
	bool bEnable = true;
	EnableFitButton(bEnable);
	
	TreeNode trPara = GetParameterTreeFromGrid();
	if(NULL != m_pNLFitSession)
		m_pNLFitSession->SetParams(trPara);//if change param in grid, dlg need update change to nlfitsession
	SetParamValToPFMTree(trPara);
	
	int nSetting = pfm_combine_exmsg_parachange_setting(bEnable, nlfit_col_to_setting(nCol) );
	post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_PARA_CHANGE, nSetting);
	*/
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS

	///Kyle 10/06/08 POST_MESSAGE_TO_XF_TO_ENABLE_FIT_BUTTON
	///Iris 10/22/2008 UPDATE_PREVIEW_FOLLOW_RETURN_VAL_OF_PARAMMANAGER_ONEDIT 
	//int nSetting = pfm_combine_exmsg_parachange_setting(true, PARMAS_SETTING_VALUES);		
	//post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_PARA_CHANGE, nSetting);
	int nNeedUpdatePreview = NLDLGPART_FITCURVE_DATA & m_nParamEditBits;
	post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_PARA_CHANGE, nNeedUpdatePreview); 
	///end UPDATE_PREVIEW_FOLLOW_RETURN_VAL_OF_PARAMMANAGER_ONEDIT
	///End POST_MESSAGE_TO_XF_TO_ENABLE_FIT_BUTTON
}


/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
/*
static int nlfit_col_to_setting(int nCol)
{
	int nSetting = -1;
	
	switch(nCol)
	{
	case GRID_COL_SHARE:
		nSetting = -1;
		break;
	case GRID_COL_FIXED:
		nSetting = PARMAS_SETTING_FIXED;
		break;
	case GRID_COL_VALUE:
		nSetting = PARMAS_SETTING_VALUES;
		break;
	case GRID_COL_SIGN_DIGITES:
		nSetting = PARMAS_SETTING_SIGN_DIGITES;
		break;
	case GRID_COL_LB:
		nSetting = PARMAS_SETTING_LOWERBOUNDS;
		break;
	case GRID_COL_UB:
		nSetting = PARMAS_SETTING_UPPERBOUNDS;
		break;
	}
	
	return nSetting;		
}
*/
///end PA_PARAM_DLG_USE_NEW_FIT_CLASS

bool	PFParamDlg::IsShowPeakTypeCol()
{
	return m_bMulFunc;
}

BOOL	PFParamDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	if ( m_bMulFunc )
	{
		nHelpID = IDD_PA_FIT_CONTROL;
		return TRUE;
	}
	return FALSE;
}

bool	PFParamDlg::Update(bool bNewGrid)// = false
{
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS	
	//Page pg = Project.Pages();
	//if(!pg)
	//{
		//Visible = false;
		//return false;
	//}
		//
	//HWND hwnd;
	//Tree tr;
	//TreeNode trPFM;
	//if(load_GetN_from_page(pg, tr,  hwnd, STR_STORAGE_NAME))
	//{
		//trPFM = tr.GetNode(PFW_TREE_TAG_NAME);//PFM_PEAKS_TREE_TAG_NAME
		//if(!trPFM) 
			//error_report("no PA tree in page tree");
	//}
	//
	//if(!trPFM)
	//{
		//Visible = false;
		//return false;
	//}
	//m_pg = pg;
	//
	//if(!trPFM)
	//{
		//Visible = false;
		//return error_report(STR_PFM_NODE + " is invalid");
	//}	
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
	
	bool	bVisible = false;		//------ Folger 10/28/08 v8.0962 CORRECTLY_UPDATE_PEAK_FIT_DIALOG_WHEN_SWITCH_PAGES
	
	if(IsInitReady())
	{
		//------ Folger 10/28/08 v8.0962 CORRECTLY_UPDATE_PEAK_FIT_DIALOG_WHEN_SWITCH_PAGES
		//Visible = true;
		Page	pg = Project.Pages();
		
		if ( pg )
		{
			GraphLayer gl;
			///------ Folger 09/27/09 QA80-14380 FIT_PEAK_PARAMETERS_DIALOG_FAILS_TO_BE_MODALESS_WHEN_SWITCH_TO_OTHER_PAGES
			//if ( m_pPeakFitHelper->GetPreviewLayer(gl) )
			if ( m_pPeakFitHelper->GetPreviewLayer(gl, false) )
			///------ End FIT_PEAK_PARAMETERS_DIALOG_FAILS_TO_BE_MODALESS_WHEN_SWITCH_TO_OTHER_PAGES
			{
				Page	pgPrev;
				gl.GetParent(pgPrev);
				if ( pg.GetName().CompareNoCase(pgPrev.GetName()) == 0 )
					bVisible = true;
			}
		}
		//------ End CORRECTLY_UPDATE_PEAK_FIT_DIALOG_WHEN_SWITCH_PAGES
	}
	
	Visible = bVisible;		//------ Folger 10/28/08 v8.0962 CORRECTLY_UPDATE_PEAK_FIT_DIALOG_WHEN_SWITCH_PAGES
	
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	/*
	m_trPFM.Replace(trPFM, true, true); 
	
	if(GetFitSessionFropPage())
		UpdateFitSession();	
	*/
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
	
	updateParameters(bNewGrid);
	
	updateButtonStatus();
	
	//------ Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
	Button btn = GetItem(IDC_PF_SWITCH_PEAK_LABEL);
	int			nLabelXYType;
	m_pPeakFitHelper->AccessPeakLabelSettings(nLabelXYType);
	btn.Check = nLabelXYType;
	//------ End SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
	
	return true;
}

void	PFParamDlg::updateButtonStatus()
{	
	vector<int> vnBtns = {IDC_PF_FIXED_BASELINE, IDC_PF_FIXED_CENTER, IDC_PF_FIXED_WIDTH, IDC_PF_SHARED_WIDTH};

	for ( int ii=0; ii<vnBtns.GetSize(); ++ii )
	{
		Button	btn = GetItem(vnBtns[ii]);
		bool	bFix = false;

		switch (vnBtns[ii])
		{
		case IDC_PF_FIXED_BASELINE:
			/// Iris 10/22/2008 NEW_PA_FIX_BUTTONS
			//m_pNLFitSession->FixBaseline(bFix, NULL, false);
			getNLParamMngr()->FixBaseline(&bFix, false);
			///end NEW_PA_FIX_BUTTONS
			break;
			
		case IDC_PF_FIXED_CENTER:
			/// Iris 10/22/2008 NEW_PA_FIX_BUTTONS
			//m_pNLFitSession->FixPeaksCenterWidth(bFix, true, false, NULL, false);
			getNLParamMngr()->FixPeaksCenterAndWidth(&bFix, true, false);
			///end NEW_PA_FIX_BUTTONS
			break;
			
		case IDC_PF_FIXED_WIDTH:
			/// Iris 10/22/2008 NEW_PA_FIX_BUTTONS
			//m_pNLFitSession->FixPeaksCenterWidth(bFix, false, true, NULL, false);
			getNLParamMngr()->FixPeaksCenterAndWidth(&bFix, false, false);
			///end NEW_PA_FIX_BUTTONS
			break;
			
		case IDC_PF_SHARED_WIDTH:
			/// Iris 10/22/2008 NEW_PA_FIX_BUTTONS
			//int nShare = bFix;
			//m_pNLFitSession->SharePeaksWidth(nShare, NULL, false);
			//bFix = nShare > 0;			
			getNLParamMngr()->SharePeaksWidth(&bFix, false);
			///end NEW_PA_FIX_BUTTONS
			break;
			
		default:
			break;
		}
		
		btn.Check = bFix;
	}
	
	Button chkAutoInit = GetItem(IDC_PF_AUTO_INIT_CHECK);
	chkAutoInit.Check = m_pNLFitSession->IsAutoRunInitParams();
		
}

/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS, will not save fit session pointer in page any more
//bool	PFParamDlg::GetFitSessionFropPage()
//{	
	//TreeNode trFitSeesion = get_fit_peak_binary_storage_tree(m_pg, STR_FIT_POINTER);	
	//DWORD dw = (DWORD)trFitSeesion.nVal;
	//m_pNLFitSession = (NLFitSession*)dw;
	//return (NULL != m_pNLFitSession);
//}
///end PA_PARAM_DLG_USE_NEW_FIT_CLASS

bool	PFParamDlg::updateParameters(bool bNewGrid, int* pnSetting)// = false, NULL
{
	if( FitParaDlg::updateParameters(bNewGrid, pnSetting) )
	{
		/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS 
		/*
		TreeNode trPara = GetParameterTreeFromGrid();
		SetParamValToPFMTree(trPara);
		*/
		///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
		
		bool bEnable, bChiSqrReady;
		if(NULL != m_pNLFitSession)
			bEnable = m_pNLFitSession->IsReadyIterations(&bChiSqrReady);	
		
		if(pnSetting)
		{
			/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS 
			//int nSetting = pfm_combine_exmsg_parachange_setting(bEnable, *pnSetting);
			//post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_PARA_CHANGE, nSetting);
		///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
		}
		return true;
	}
	return false;
}

/// virtual
int PFParamDlg::getParameterGroups()
{
	return m_pNLFitSession->GetNumPeaks();
}

/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
/*
/// virtual
bool PFParamDlg::setParameterTreeToGrid()
{
	TreeNode trPara = m_pNLFitSession->GetSessionTree().GetNode(STR_PARAM_SETTING);
	
	///Jasmine 03/31/08 ALLOW_CHANGE_FUNCTION_IN_PARAM_DLG
	TreeNode trPeakType = trPara.PeakType;
	if(trPeakType)
	{
		string strBaselineFunc, strBaselineFuncList;
		if(m_pNLFitSession->HasBaselinePeak(&strBaselineFunc))
		{
			trPeakType.SetAttribute(STR_NAME_ATTRIB, strBaselineFunc);
			
			TreeNode trBaselinePeak = tree_get_node_by_tagname(m_trPFM, PFM_BASELINE_PEAK_TAG_NAME, true);
			if(trBaselinePeak)
				trBaselinePeak.GetAttribute(STR_COMBO_ATTRIB, strBaselineFuncList);
			
			if( !strBaselineFuncList.IsEmpty() )
				trPeakType.SetAttribute(STR_BASELINE_FUNCS_ATTRIB, strBaselineFuncList);
			
		}
	}
	///End ALLOW_CHANGE_FUNCTION_IN_PARAM_DLG
	
	if(SetParameterTree(trPara))
	{		
		//vector vd;
		//vd = trPara.Values.dVals;
		//int nNumPara = vd.GetSize();		
		return true;
	}
	return false;
}
*/
///end PA_PARAM_DLG_USE_NEW_FIT_CLASS

/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
/*
bool PFParamDlg::SetParamValToPFMTree(const TreeNode&trPara)
{
	vector vParams;
	vParams = trPara.Values.dVals;
	int nSize = vParams.GetSize();
	int nOffset = (NULL != m_pNLFitSession && m_pNLFitSession->HasBaselinePeak())? 0 : 1;
	int nCurrent;
	for(int ii = 0; ; ii++)
	{
		string strName = "Peak" + (string)(ii+nOffset);
		TreeNode trPeak = tree_get_node_by_tagname(m_trPFM, strName, true);
		if(!trPeak.IsValid())
			break;
		TreeNode trParams = trPeak.GetNode("Parameters");
		foreach( TreeNode trNode in trParams.Children )
		{
			//since trPara has only one offset parameter, y0 or z0
			//skip offset parameter in peaks except 1st peak
			if(0 == trNode.tagName.CompareNoCase(STR_OFFSET_PARAM_NAME_PFM) || 0 == trNode.tagName.CompareNoCase(STR_OFFSET_PARAM_NAME_SPFM))
			{
				if(ii > nOffset)
					continue;
			}
			//trNode.dVal = nCurrent < nSize? vParams[nCurrent] : NANUM;///Jasmne 10/22/07 QA70-10543 PFM_TREE_STRUCTURE_CHANGE
			trNode.Value.dVal = nCurrent < nSize? vParams[nCurrent] : NANUM;
			nCurrent++;
		}
	}
	HWND hwnd;
	Tree tr;
	if(load_GetN_from_page(m_pg, tr,  hwnd, STR_STORAGE_NAME))
	{
		TreeNode trPFM = tr.GetNode(PFW_TREE_TAG_NAME);//PFM_PEAKS_TREE_TAG_NAME	
		if(trPFM)
		{
			trPFM.Replace(m_trPFM, true, true);
			save_GetN_to_page(m_pg, tr,  hwnd, STR_STORAGE_NAME);
			return true;
		}
	}
	return false;
}
*/
///end PA_PARAM_DLG_USE_NEW_FIT_CLASS

//virtual 
///Jasmine 07/17/07 DISABLE_FIT_BUTTON_AFTER_FITTING_IS_OK
void PFParamDlg::EnableFitButton(bool bEnable)
{
	GetItem(IDC_PF_ONE_LTER).Enable = bEnable;
	GetItem(IDC_PF_FIT).Enable = bEnable;
}
///End DISABLE_FIT_BUTTON_AFTER_FITTING_IS_OK	

///------ Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
BOOL	PFParamDlg::UpdateParameterHide(bool bShowGetNDialog/* = true*/)
{
	///------ Folger 06/29/09 IMPROVE_HIDE_PARAMETER_DIALOG_IN_NANOSIZER
	//vector<string> vsParams;
	//getNLParamMngr()->GetColumn(NLPARAMGRIDCOLTYPE_NAME, vsParams);
	//
	//vector<string> vsParamsPre = { "y", "xc", "A", "w" };
	//#define		NUM_PARAMETER_PREFIX	4
	//
	//updateHiddenParamsInfo();
		//
	//vector<int>				vnChecked(NUM_PARAMETER_PREFIX);
	//vnChecked = 0; // Hong, explicit initialization /// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	//vector<int>				vnIndecies[NUM_PARAMETER_PREFIX];
	//for ( int ii=0; ii<vsParams.GetSize(); ++ii )
	//{
		//for ( int jj=0; jj<NUM_PARAMETER_PREFIX; ++jj )
		//{
			//vsParams[ii].MakeLower();
			//vsParamsPre[jj].MakeLower();
			//if ( vsParams[ii].Find(vsParamsPre[jj]) >= 0 )
			//{
				//vnIndecies[jj].Add(ii);
			//}
		//}
	//}
	//
	//TreeNodeCollection trNs;
	//vector<string> vsLabel;
	//for(int  kk = 0; kk < vsParamsPre.GetSize(); kk++ )
		//vsLabel.Add(vsParamsPre[kk] + STR_THREE_DOTS);
	updateHiddenParamsInfo();

	#define		MAX_NUM_PARAMETER_PREFIX	20
	vector<int>				vnIndecies[MAX_NUM_PARAMETER_PREFIX];

	TreeNodeCollection trNs;
	vector<string> vsLabel;
	
	if ( m_bMulFunc )	
	{	
		vector<string> vsParams;
		getNLParamMngr()->GetColumn(NLPARAMGRIDCOLTYPE_NAME, vsParams);
		
		vector<string> vsParamsPre = { "y", "xc", "A", "w" };

		for ( int ii=0; ii<vsParams.GetSize(); ++ii )
		{
			for ( int jj=0; jj<vsParamsPre.GetSize(); ++jj )
			{
				vsParams[ii].MakeLower();
				vsParamsPre[jj].MakeLower();
				if ( vsParams[ii].Find(vsParamsPre[jj]) >= 0 )
				{
					vnIndecies[jj].Add(ii);
				}
			}
		}

		for(int  kk = 0; kk < vsParamsPre.GetSize(); kk++ )
			vsLabel.Add(vsParamsPre[kk] + STR_THREE_DOTS);
	}
	else
	{
		int		nReplicaOffset = m_pNLFitSession->GetReplicaOffsetFromFDF() - 1;
		int		nReplicaUnit = m_pNLFitSession->GetReplicaUnitFromFDF();

		int		nNumMultiplicity = m_pNLFitSession->GetNumberMultiplicity();
		m_pNLFitSession->GetParamNamesInFunction(vsLabel);
		vnIndecies[0].Data(0, nReplicaOffset - 1);
		for ( int ii=nReplicaOffset; ii<vsLabel.GetSize(); ++ii )
		{
			for ( int jj=0; jj<nNumMultiplicity; ++jj )
			{
				vnIndecies[ii].Add(ii + jj * nReplicaUnit);
			}
		}
	}

	vector<int>				vnChecked(vsLabel.GetSize());
	vnChecked = 0; // Hong, explicit initialization /// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	///------ End IMPROVE_HIDE_PARAMETER_DIALOG_IN_NANOSIZER
	int			nGroupToShow = PARMAS_GROUP_TYPE_NOT_SHARE_GROUP;
	if( OpenHideParamRowsBox( trNs, vnChecked, vsLabel, &nGroupToShow, bShowGetNDialog) )
	{
		if ( PARMAS_GROUP_TYPE_NOT_SHARE_GROUP == nGroupToShow )
			m_vnParamsHide = 0; // reset to show all
		
		int index = 0;
		foreach(TreeNode trN in trNs)
		{
			for ( int jj=0; jj<vnIndecies[index].GetSize(); ++jj )
				m_vnParamsHide[vnIndecies[index][jj]] = trN.nVal;
			index++;
		}
		customParamRowsShow(true, &nGroupToShow);
	}
	
	return true;
}
///------ End PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED

//------ Folger 04/30/08 QA80-11479 ADD_HIDE_BUTTON_FOR_PA
//virtual
BOOL PFParamDlg::OnClickParamHide(Control ctrl)
{
	///------ Folger 06/29/09 IMPROVE_HIDE_PARAMETER_DIALOG_IN_NANOSIZER
	//if ( !m_bMulFunc )
		//return FitParaDlg::OnClickParamHide(ctrl);
	///------ End IMPROVE_HIDE_PARAMETER_DIALOG_IN_NANOSIZER
	
	///------ Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
	////string strNodePre = "P";				///Kyle 09/10/08 USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
	//vector<string> vsParams;
	/////Kyle 09/09/08 USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
	////TreeNode trParameter = m_pGridParas->GetParamTree();
	////vsParams = trParameter.Names.strVals;
	//getNLParamMngr()->GetColumn(NLPARAMGRIDCOLTYPE_NAME, vsParams);
	/////End USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
	//
	////this two must be modified together
	//vector<string> vsParamsPre = { "y", "xc", "A", "w" };
	//#define		NUM_PARAMETER_PREFIX	4
	//
	//updateHiddenParamsInfo();
		//
	//vector<int>				vnChecked(NUM_PARAMETER_PREFIX);
	//vnChecked = 0; // Hong, explicit initialization /// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	//vector<int>				vnIndecies[NUM_PARAMETER_PREFIX];
	//for ( int ii=0; ii<vsParams.GetSize(); ++ii )
	//{
		//for ( int jj=0; jj<NUM_PARAMETER_PREFIX; ++jj )
		//{
			///// Folger, 10/27/08, should use more common code to compare chars
			////if ( (vsParams[ii][0] & ~(1 << 5)) == (vsParamsPre[jj][0] & ~(1 << 5)) )		//all to upper case
			//vsParams[ii].MakeLower();
			/////------ Folger 01/06/09 8.0993e MAKE_MORE_CLEAR_PARAMETER_NAMES_PREFIX_FOR_HIDDEN
			////if ( vsParams[ii][0] == vsParamsPre[jj][0] )
			//vsParamsPre[jj].MakeLower();
			//if ( vsParams[ii].Find(vsParamsPre[jj]) >= 0 )
			/////------ End MAKE_MORE_CLEAR_PARAMETER_NAMES_PREFIX_FOR_HIDDEN
			//{
				//vnIndecies[jj].Add(ii);
				///// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
				//// Hong, it will be complex to init with last setting after add group, so init to all uncheck
				////if ( !vnChecked[jj] && m_vnParamsHide[ii] )
				////	vnChecked[jj] = 1;
				///// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
			//}
		//}
	//}	
	/////Kyle 09/10/08 USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
	////GETN_TREE(trParamHide)
	////for(int nn = 0;  nn < NUM_PARAMETER_PREFIX; nn++)
	////{
		////string strTagName = strNodePre + (nn+1);
		////TreeNode trN = trParamHide.AddNode(strTagName, TRGP_CHECK);
		////trN.nVal = vnChecked[nn];
		////trN.SetAttribute(STR_LABEL_ATTRIB, vsParamsPre[nn] + STR_THREE_DOTS);
	////}
	////
	////if( GetNBox(trParamHide, STR_HIDE_PARAMETERS_DIALOG_TITLE, STR_HIDE_PARAMETERS_DIALOG_DESCRIPTION, NULL, NULL) )
	//TreeNodeCollection trNs;
	//vector<string> vsLabel;
	/////Sophy 12/3/2008 v8.0982 IMPROVE_PARAM_SETTING_DIALOG_GIVE_REASONAL_HINTS
	////vsLabel = vsParamsPre + STR_THREE_DOTS;
	//for(int  kk = 0; kk < vsParamsPre.GetSize(); kk++ )
		//vsLabel.Add(vsParamsPre[kk] + STR_THREE_DOTS);
	/////end IMPROVE_PARAM_SETTING_DIALOG_GIVE_REASONAL_HINTS
	///// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	////if( OpenHideParamRowsBox( trNs, vnChecked, vsLabel) )
	//int			nGroupToShow = PARMAS_GROUP_TYPE_NOT_SHARE_GROUP;
	//if( OpenHideParamRowsBox( trNs, vnChecked, vsLabel, &nGroupToShow) )
	///// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	/////End USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
	//{
		///// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
		//if ( PARMAS_GROUP_TYPE_NOT_SHARE_GROUP == nGroupToShow )
			//m_vnParamsHide = 0; // reset to show all
		///// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
		//int index = 0;
		////TreeNodeCollection trNs(trParamHide, strNodePre);			///Kyle 09/10/08 USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
		//foreach(TreeNode trN in trNs)
		//{
			//for ( int jj=0; jj<vnIndecies[index].GetSize(); ++jj )
				//m_vnParamsHide[vnIndecies[index][jj]] = trN.nVal;
			//index++;
		//}
		///// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
		////customParamRowsShow();
		//customParamRowsShow(true, &nGroupToShow);
		///// IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	//}
	//
	//return true;
	return UpdateParameterHide();
	///------ End PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
}

/// Hong 12/10/08 QA80-12744 IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL
// virtual
void 	PFParamDlg::OnAfterSelChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel)
{
	///------ Folger 12/15/08 v8.0986c PARAMETER_GRID_RUNTIME_ERROR_WHEN_CHANGE_FIX_STATUS_THEN_FIT
	//if ( !m_pGridParas->IsReady() )
	if ( !m_pGridParas->IsReady() || m_pGridParas->GetNumRows() == 0 )
	///------ End PARAMETER_GRID_RUNTIME_ERROR_WHEN_CHANGE_FIX_STATUS_THEN_FIT
		return ;
	
	FitParaDlg::OnAfterSelChange(cntrl, nOldRowSel, nOldColSel, nNewRowSel, nNewColSel);
	
	BOOL		bCancel = FALSE;
	OnBeforeEditParaControl(cntrl, nOldRowSel, nOldColSel, &bCancel);
	if ( !bCancel )
		m_pGridParas->SetBold(nOldRowSel, nOldColSel, FALSE);
	bCancel = FALSE;
	OnBeforeEditParaControl(cntrl, nNewRowSel, nNewColSel, &bCancel);
	if ( !bCancel )
		m_pGridParas->SetBold(nNewRowSel, nNewColSel, TRUE);
}
/// end IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL

/// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
//virtual	bool	PFParamDlg::customParamRowsShow(bool bUpdateGird)
virtual	bool	PFParamDlg::customParamRowsShow(bool bUpdateGird/* = true*/, int* pnGroupToShow/* = NULL*/)
/// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
{
	/// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	//if ( !m_bMulFunc )
	//	return FitParaDlg::customParamRowsShow(bUpdateGird);
	if ( !m_bMulFunc )
	{
		if ( !FitParaDlg::customParamRowsShow(false, pnGroupToShow) )
			return false;
	}	
	if ( pnGroupToShow && PARMAS_GROUP_TYPE_NOT_SHARE_GROUP != *pnGroupToShow )
	{
		vector<int>		vnIndices;
		if ( 0 < m_pNLFitSession->GetNLParamsMngr()->GetParamIndicesByGroupIndex(vnIndices, *pnGroupToShow) )
		{
			vector<int>		vnParamsHide;
			vnParamsHide = m_vnParamsHide;
			m_vnParamsHide = 1;
			for ( int ii = 0; ii < vnIndices.GetSize(); ii++ )
			{
				if ( vnIndices[ii] > m_vnParamsHide.GetSize() )
					continue;
				m_vnParamsHide[vnIndices[ii]] = vnParamsHide[vnIndices[ii]];
			}
		}
	}
	/// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	///Kyle 09/10/08 Kyle 09/10/08 CHANGE_PROTOTYPE_OF_HIDEPARAMROWS_AND_REMOVE_SETPARAMROWSSHOW
	//m_pGridParas->SetParamRowsShow(m_vnParamsHide);	
	//m_pGridParas->HideParamRows();
	m_pGridParas->HideParamRows(m_vnParamsHide);
	///End Kyle 09/10/08 CHANGE_PROTOTYPE_OF_HIDEPARAMROWS_AND_REMOVE_SETPARAMROWSSHOW
	return true;
}

// virtual
int PFParamDlg::getToltalNumParams()
{
	vector<string> vsParams;
	return getNLParamMngr()->GetColumn(NLPARAMGRIDCOLTYPE_NAME, vsParams);
}

virtual bool	PFParamDlg::updateHiddenParamsInfo()
{
	if ( !m_bMulFunc )
		return FitParaDlg::updateHiddenParamsInfo();
	
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	/*
	vector<string> vsParams;
	TreeNode trParameter = m_pGridParas->GetParamTree();
	vsParams = trParameter.Names.strVals;
	if( m_vnParamsHide.GetSize() != vsParams.GetSize() )
	*/
	int nParams = getToltalNumParams();
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
	if( m_vnParamsHide.GetSize() != nParams )
	{
		/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
		//m_vnParamsHide.SetSize(vsParams.GetSize());
		m_vnParamsHide.SetSize(nParams);
		///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
		m_vnParamsHide = 0;
		return true;
	}	
	return false;
	
}
//------ End QA80-11479 ADD_HIDE_BUTTON_FOR_PA

///------ Folger 03/09/09 PROPER_HANDLE_OF_MAX_NUM_ITERATE_IN_FIT_PARAM_DIALOG
////virtual 
//int PFParamDlg::getMaxIterationNum()
//{	
	////return m_trAdvanced.MaxNum.nVal;;	///Jasmine 03/11/08 SHOW_FITCONTROL_BRANCH_IN_XF_NOT_IN_PARAMDLG_BY_CP_REQUEST
	///// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS, to do 
	////return m_pNLFitSession->GetNumMaxIter();
	//return 100;
	/////end PA_PARAM_DLG_USE_NEW_FIT_CLASS
//}
///------ End PROPER_HANDLE_OF_MAX_NUM_ITERATE_IN_FIT_PARAM_DIALOG

////virtual
//bool PFParamDlg::afterIterate(bool bEnable)
//{
	////post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_ADV_CHANGE);//why post here? to update xf's fit button status?
	//post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_PARA_CHANGE, bEnable);
	//return true;
//}
///---Sim 02-25-2008 NO_FIT_AGAIN_CHECK_BOX
//virtual
bool PFParamDlg::afterIterate(bool bEnable)
{
	post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_AFT_ITR, m_pNLFitSession->GetNumberItersPerformed());
	return true;
}
///---END NO_FIT_AGAIN_CHECK_BOX

void	PFParamDlg::onAfterFunctionChanged()
{
	m_vnParamsHide.SetSize(0);
	///Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION
	//m_pGridParas->Update();
	m_pGridParas->Update( m_pNLFitSession->IsAllowSharing() );
	///End USE_ISALLOWSHARING_IN_NLFSESSION
	///Sophy 9/12/2008 CLEAN_PA_PREVIEW_FOR_81
	post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_FUNC_CHANGE);
	///end CLEAN_PA_PREVIEW_FOR_81
	EnableFitButton(true);	
	
	
}

///Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
// virtual
void PFParamDlg::updateOnParameterChange(int nUpdateParts )
{
	if( nUpdateParts > 0 )
	{	
		int nNeedUpdatePreview = 1;
		post_getn_dialog_message(WM_USER_EXTERNAL_MSG, EXTERNAL_MSG_PARA_CHANGE, nNeedUpdatePreview); 
	}
	return;
}
///End QUICK_SET_PARAMETERS_VALUE_CHANGE

///------ Folger 01/05/09 v8.0993d REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
/// virtual
TreeNode	PFParamDlg::getParamHideTree(const vector<int>& vnParamsHide, const vector<string> & vsLabel, string* pstrNodePre/* = NULL*/, bool bAddGroupShowCombo/* = false*/)
{
	if ( m_trParamHide.IsEmpty() )
		m_pPeakFitHelper->SetGetParamHideTree(m_trParamHide, false);
	
	return FitParaDlg::getParamHideTree(vnParamsHide, vsLabel, pstrNodePre, bAddGroupShowCombo);
}
///------ End REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG

///------ Folger 07/14/09 NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION
/// virtual
void		PFParamDlg::ResetParamHideTree()
{
	FitParaDlg::ResetParamHideTree();
	m_pPeakFitHelper->SetGetParamHideTree(NULL, true);
}
///------ End NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION

bool FitPeakDlg(PeakFitHelperBase *pFitHelper, int nMsg, DWORD dwCntrl)
{	
	bool bClose = OMSG_CLOSE==nMsg? true:false;
	bool bUpdate = OMSG_UPDATE==nMsg? true:false;
	
	PFParamDlg		*pPFDlg = pFitHelper->GetPeakFitDlgPointer();	//------ Folger 10/28/08 v8.0962 CORRECTLY_UPDATE_PEAK_FIT_DIALOG_WHEN_SWITCH_PAGES

	if(bClose)
	{
		if(pPFDlg)
		{
			Window winDlg = pPFDlg->GetWindow();
			if(winDlg)
				winDlg.SendMessage(WM_CLOSE);
			/// Folger, 12/10/08, this code is not correct, should delete PFDlg pointer inside PFDlg::OnDestroy
			/*
			//delete pPFDlg;
			//------ Folger 10/28/08 v8.0962 CORRECTLY_UPDATE_PEAK_FIT_DIALOG_WHEN_SWITCH_PAGES
			//pPFDlg = NULL;
			pFitHelper->SetPeakFitDlgPointer(NULL);
			//------
			*/
		}
		return true;
	}
	
	if(bUpdate)
	{
		// no need update if not open dialog 
		if( NULL == pPFDlg )
			return false;
		
		///Sophy 12/2/2008 v8.981b UPDATE_OK_BUTTON_AND_RELATIVE_FIT_BUTTONS_ON_ERROR
		if( PARAM_DLG_ENABLE_OK & dwCntrl || PARAM_DLG_DISABLE_OK & dwCntrl )
		{
			bool bEnable = PARAM_DLG_ENABLE_OK & dwCntrl;
			pPFDlg->EnableOKButton(bEnable);
		}
		///end UPDATE_OK_BUTTON_AND_RELATIVE_FIT_BUTTONS_ON_ERROR
		if( (PARAM_DLG_ENABLE_FIT & dwCntrl) || (PARAM_DLG_DISABLE_FIT & dwCntrl) )
		{
			bool bEnable = PARAM_DLG_ENABLE_FIT & dwCntrl;
			pPFDlg->EnableFitButton(bEnable);
		}
		
		if( (PARAM_DLG_NEW_GRID & dwCntrl) || (PARAM_DLG_UPDATE_GRID & dwCntrl) )
		{
			pPFDlg->UpdateParameterHide(false);		///------ Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
			bool bNewGrid = PARAM_DLG_NEW_GRID & dwCntrl;
			pPFDlg->Update(bNewGrid);	
		}
		return true;
	}
	
	// open 
	if(!pPFDlg)
	{
		/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS		
		//bool bMulFunc = PARAM_DLG_MULTI_FUNC & dwCntrl;
		//bool bShowAdvBtn = PARAM_DLG_ADVANCE & dwCntrl;
		//s_pPAPDlg = new PFParamDlg(bMulFunc, bShowAdvBtn);
		//s_pPAPDlg->Create(GetWindow());
		bool bMulFunc = PARAM_DLG_MULTI_FUNC & dwCntrl; 
		pPFDlg = new PFParamDlg(pFitHelper, bMulFunc);
		///Kyle 09/16/08 MOVE_DELETE_THIS_FROM_ONDESTROY_TO_GLOBAL_FUNCTION		
		pPFDlg->Create(GetWindow());
		///End MOVE_DELETE_THIS_FROM_ONDESTROY_TO_GLOBAL_FUNCTION
		///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
		
		pPFDlg->UpdateParameterHide(false);			///------ Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
		
		pFitHelper->SetPeakFitDlgPointer(pPFDlg);	//------ Folger 10/28/08 v8.0962 CORRECTLY_UPDATE_PEAK_FIT_DIALOG_WHEN_SWITCH_PAGES
	}
	//pPFDlg->Create(GetWindow());		///Kyle 09/16/08 MOVE_DELETE_THIS_FROM_ONDESTROY_TO_GLOBAL_FUNCTION
	
	return true;
}